

cd('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\SO2');

currdir = dir;
time = [];
so2 = [];


for i = 1:length(currdir)
	
	cdfcheck = ~isempty(strfind(currdir(i).name,'.cdf')) || ~isempty(strfind(currdir(i).name,'.nc'));
	if cdfcheck == 0
		continue
	end
	currfile = currdir(i).name;
	datestartidx = 17;
	year_range = datestartidx : datestartidx +3;
	month_range = datestartidx +4 : datestartidx +5;
	day_range = datestartidx +6 : datestartidx +7;
	startdate = [str2num(currfile(year_range)), str2num(currfile(month_range)), str2num(currfile(day_range)), 0, 0, 0];
	sec_time = ncread(currfile,'time');
	
	currtimemat = repmat(startdate,length(sec_time),1);
	currtimemat(:,6) = currtimemat(:,6) + sec_time;
	currtimemat = datetime(currtimemat);
	time = [time ; currtimemat];
	
	currso2 = ncread(currfile,'so2');
	so2 = [so2; currso2];
	
	
end

so2(so2>4) = NaN;